/*
 * Decompiled with CFR 0.152.
 */
package dev.codenmore.tilegame.entities.creatures;

import dev.codenmore.tilegame.Handler;
import dev.codenmore.tilegame.entities.creatures.Creature;
import dev.codenmore.tilegame.gfx.Animation;
import dev.codenmore.tilegame.gfx.Assets;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class Player2
extends Creature {
    private Animation anim;
    private Animation animLeft;
    private Animation animRight;
    private Animation leftPunch;
    private Animation rightPunch;
    private Animation leftKick;
    private Animation rightKick;
    private Animation leftSuper;
    private Animation rightSuper;
    private String lastCharacter = "viking";
    private String character = "viking";
    private int counter = 30;

    public Player2(Handler handler, float x, float y) {
        super(handler, x, y, 320, 320);
        this.bounds.x = 80;
        this.bounds.y = 160;
        this.bounds.width = 135;
        this.bounds.height = 160;
        this.setCharacterAnimStats();
    }

    @Override
    public void tick() {
        if (!this.character.equals(this.lastCharacter)) {
            this.lastCharacter = this.character;
            this.setCharacterAnimStats();
        }
        this.animLeft.tick();
        this.animRight.tick();
        if (((Creature)this).leftKick) {
            this.leftKick.tick();
        }
        if (((Creature)this).rightKick) {
            this.rightKick.tick();
        }
        if (this.counter != 30) {
            ++this.counter;
        }
        if (this.attackCounter != 0) {
            --this.attackCounter;
        }
        if (this.attackCounter == 0) {
            ((Creature)this).leftPunch = false;
            ((Creature)this).rightPunch = false;
            ((Creature)this).leftKick = false;
            ((Creature)this).rightKick = false;
            this.leftsuper = false;
            ((Creature)this).rightSuper = false;
        }
        if (this.blockCounter != 0) {
            --this.blockCounter;
        }
        if (this.blockCounter == 0) {
            this.block = false;
        }
        if (this.blockCounter2 != 0) {
            --this.blockCounter2;
        }
        this.getInput();
        this.move();
        this.handler.getGameCamera().centerOnEntity(this);
    }

    private void getInput() {
        this.xMove = 0.0f;
        this.yMove = 0.0f;
        if (!this.jUp) {
            this.yMove = this.jump;
        }
        if (this.handler.getKeyManager().p2Up && !this.jUp && this.jumpCount == this.jump_frames) {
            this.yMove = -this.jump;
        }
        if (this.jUp && this.jumpCount > 0) {
            this.yMove = -this.jump;
        }
        if (this.handler.getKeyManager().p2Left) {
            this.xMove = -this.speed;
        }
        if (this.handler.getKeyManager().p2Right) {
            this.xMove = this.speed;
        }
        if (this.handler.getKeyManager().p2Punch && !this.handler.getGame().getGameState().getPlayer().isBlock() && Math.abs(this.getX() - this.handler.getGame().getGameState().getPlayer().getX()) < 150.0f && this.counter == 30) {
            this.counter = 0;
            this.handler.getGame().getGameState().getPlayer().setHealth(this.handler.getGame().getGameState().getPlayer().getHealth() - this.power);
            if (this.handler.getGame().getGameState().getPlayer().getHealth() < 0) {
                this.handler.getGame().getGameState().getPlayer().setHealth(0);
            }
        }
        if (this.handler.getKeyManager().p2Kick && Math.abs(this.getX() - this.handler.getGame().getGameState().getPlayer().getX()) < 150.0f && Math.abs(this.getY() - this.handler.getGame().getGameState().getPlayer().getY()) == 0.0f && this.counter == 30) {
            if (this.getX() - this.handler.getGame().getGameState().getPlayer().getX() > 0.0f) {
                ((Creature)this).leftKick = true;
                this.attackCounter = 25;
            }
            if (this.getX() - this.handler.getGame().getGameState().getPlayer().getX() < 0.0f) {
                ((Creature)this).rightKick = true;
                this.attackCounter = 25;
            }
            this.counter = 0;
            this.handler.getGame().getGameState().getPlayer().setHealth(this.handler.getGame().getGameState().getPlayer().getHealth() - (this.power + 2));
            if (this.handler.getGame().getGameState().getPlayer().getHealth() < 0) {
                this.handler.getGame().getGameState().getPlayer().setHealth(0);
            }
        } else if (this.handler.getKeyManager().p2Super && !this.handler.getGame().getGameState().getPlayer().isBlock() && Math.abs(this.getX() - this.handler.getGame().getGameState().getPlayer().getX()) < 150.0f && !this.superUsed && this.counter == 30) {
            this.counter = 0;
            this.superUsed = true;
            this.handler.getGame().getGameState().getPlayer().setHealth(this.handler.getGame().getGameState().getPlayer().getHealth() - this.superPower);
            if (this.handler.getGame().getGameState().getPlayer().getHealth() < 0) {
                this.handler.getGame().getGameState().getPlayer().setHealth(0);
            }
        } else if (this.handler.getKeyManager().p2Block && !this.block && this.blockCounter2 == 0) {
            this.block = true;
            this.blockCounter = 60;
            this.blockCounter2 = 300;
        }
    }

    @Override
    public void render(Graphics g) {
        g.drawImage(this.getCurrentAnimationFrame(), (int)(this.x - this.handler.getGameCamera().getxOffset()), (int)(this.y - this.handler.getGameCamera().getyOffset()), this.width, this.height, null);
    }

    private BufferedImage getCurrentAnimationFrame() {
        if (((Creature)this).leftKick) {
            return this.leftKick.getCurrentFrame();
        }
        if (((Creature)this).rightKick) {
            return this.rightKick.getCurrentFrame();
        }
        if (this.xMove < 0.0f) {
            return this.animLeft.getCurrentFrame();
        }
        if (this.xMove > 0.0f) {
            return this.animRight.getCurrentFrame();
        }
        return this.anim.getCurrentFrame();
    }

    public String getCharacter() {
        return this.character;
    }

    public void setCharacter(String character) {
        this.character = character;
    }

    private void setCharacterAnimStats() {
        if (this.character.equals("viking")) {
            this.anim = new Animation(500, Assets.viking);
            this.animLeft = new Animation(175, Assets.vikingLeft);
            this.animRight = new Animation(175, Assets.vikingRight);
            this.leftPunch = new Animation(175, Assets.vikingLeft);
            this.rightPunch = new Animation(175, Assets.vikingRight);
            this.leftKick = new Animation(75, Assets.vikingLeftKick);
            this.rightKick = new Animation(75, Assets.vikingRightKick);
            this.leftSuper = new Animation(175, Assets.vikingLeft);
            this.rightSuper = new Animation(175, Assets.vikingRight);
            this.power = 8;
            this.superPower = 50;
            this.jumpCount = this.jump_frames = 10;
            this.speed = 1.0f;
        } else if (this.character.equals("soldier")) {
            this.anim = new Animation(500, Assets.soldier);
            this.animLeft = new Animation(175, Assets.soldierLeft);
            this.animRight = new Animation(175, Assets.soldierRight);
            this.leftPunch = new Animation(175, Assets.soldierLeft);
            this.rightPunch = new Animation(175, Assets.soldierRight);
            this.leftKick = new Animation(175, Assets.soldierLeft);
            this.rightKick = new Animation(75, Assets.soldierRight);
            this.leftSuper = new Animation(175, Assets.soldierLeft);
            this.rightSuper = new Animation(175, Assets.soldierRight);
            this.power = 7;
            this.superPower = 55;
            this.jumpCount = this.jump_frames = 10;
            this.speed = 3.0f;
        } else if (this.character.equals("knight")) {
            this.anim = new Animation(500, Assets.knight);
            this.animLeft = new Animation(175, Assets.knightLeft);
            this.animRight = new Animation(175, Assets.knightRight);
            this.leftPunch = new Animation(175, Assets.knightLeft);
            this.rightPunch = new Animation(175, Assets.knightRight);
            this.leftKick = new Animation(75, Assets.knightLeftKick);
            this.rightKick = new Animation(75, Assets.knightRightKick);
            this.leftSuper = new Animation(175, Assets.knightLeft);
            this.rightSuper = new Animation(175, Assets.knightRight);
            this.power = 3;
            this.superPower = 30;
            this.jumpCount = this.jump_frames = 25;
            this.speed = 3.0f;
        } else if (this.character.equals("ninja")) {
            this.anim = new Animation(500, Assets.body);
            this.animLeft = new Animation(500, Assets.body);
            this.animRight = new Animation(500, Assets.body);
            this.leftPunch = new Animation(175, Assets.body);
            this.rightPunch = new Animation(175, Assets.body);
            this.leftKick = new Animation(175, Assets.body);
            this.rightKick = new Animation(75, Assets.body);
            this.rightKick = new Animation(75, Assets.body);
            this.leftSuper = new Animation(175, Assets.body);
            this.rightSuper = new Animation(175, Assets.body);
            this.power = 4;
            this.superPower = 25;
            this.jumpCount = this.jump_frames = 35;
            this.speed = 2.0f;
        } else if (this.character.equals("robot")) {
            this.anim = new Animation(500, Assets.body);
            this.animLeft = new Animation(500, Assets.body);
            this.animRight = new Animation(500, Assets.body);
            this.leftPunch = new Animation(175, Assets.body);
            this.rightPunch = new Animation(175, Assets.body);
            this.leftKick = new Animation(175, Assets.body);
            this.rightKick = new Animation(75, Assets.body);
            this.rightKick = new Animation(75, Assets.body);
            this.leftSuper = new Animation(175, Assets.body);
            this.rightSuper = new Animation(175, Assets.body);
            this.power = 5;
            this.superPower = 40;
            this.jumpCount = this.jump_frames = 10;
            this.speed = 5.0f;
        } else if (this.character.equals("warrior")) {
            this.anim = new Animation(500, Assets.body);
            this.animLeft = new Animation(500, Assets.body);
            this.animRight = new Animation(500, Assets.body);
            this.leftPunch = new Animation(175, Assets.body);
            this.rightPunch = new Animation(175, Assets.body);
            this.leftKick = new Animation(175, Assets.body);
            this.rightKick = new Animation(75, Assets.body);
            this.rightKick = new Animation(75, Assets.body);
            this.leftSuper = new Animation(175, Assets.body);
            this.rightSuper = new Animation(175, Assets.body);
            this.power = 6;
            this.superPower = 35;
            this.jumpCount = this.jump_frames = 10;
            this.speed = 7.0f;
        }
    }
}

